*Exploration of main variables for inequality and social class paper

*Tim Goedemé, 20/05/2019

/*

Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License. 
This file can be changed and re-shared for non-commercial use, as long as our original work 
is recognised and the revised work is made available under the same conditions.

When using this do-file, please cite as:
Goedemé, T., Nolan, B., Paskov, M., & Weisstanner, D. (2021). 
Occupational Social Class and Earnings Inequality in Europe: A Comparative Assessment. 
In: Social Indicators Research. DOI: https://doi.org/10.1007/s11205-021-02746-z; https://timgoedeme.com/tools/esec-in-eu-silc/

*/

*Globals
********

global place1 <<directory of microdata>>
global countries AT BE BG CH CY CZ DE DK EE EL ES FI FR HR HU IE IS IT LT LU LV MT NL NO PL PT RO RS SE SI SK UK





*1. Country datasets with all variables
***************************************

foreach ctry of global countries {
	forvalues year = 2004(1)2018 {
		clear
		cap confirm file "${place1}\`ctry'\\`year'\UDB_c`ctry'`year'D_sd.dta"
		if _rc==0 {
			
			di "`year'; `ctry'"
			use "${place1}\`ctry'\\`year'\UDB_c`ctry'`year'D_sd.dta"
			merge 1:1 year country hid using "${place1}\`ctry'\\`year'\UDB_c`ctry'`year'H.dta"
			cap drop _merge
			merge 1:m year country hid using "${place1}\`ctry'\\`year'\UDB_c`ctry'`year'R.dta"
			cap drop _merge
			merge 1:1 year country pid using "${place1}\`ctry'\\`year'\UDB_c`ctry'`year'P.dta"
			cap drop _merge
			compress
			
			save "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta", replace
		}
	}
}

